<?php
header('Content-Type: application/json');
require 'db.php'; // Assuming this contains the database conn

// Initialize response array
$response = array('status' => 'error', 'message' => 'Unknown error');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve and process the payload data
    $notes = isset($_POST['notes']) ? mysqli_real_escape_string($conn, $_POST['notes']) : '';
    $terms = isset($_POST['terms']) ? mysqli_real_escape_string($conn, $_POST['terms']) : '';
    $template_file = isset($_POST['template_file']) ? mysqli_real_escape_string($conn, $_POST['template_file']) : '';
    $colour_code = isset($_POST['colour_code']) ? mysqli_real_escape_string($conn, $_POST['colour_code']) : '';

    
    // For the image
    $qrImagePath = ''; // Initialize image path variable
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $imageTmpName = $_FILES['image']['tmp_name'];
        $imageName = $_FILES['image']['name'];
        // Save the image to a specific path (e.g., 'uploads/')
        $qrImagePath = 'qrcode/' . uniqid() . '-' . basename($imageName);
        move_uploaded_file($imageTmpName, $qrImagePath); // Save the image to the path
        $imageSize = filesize($imageTmpName);
    } else {
        $imageSize = 0;
    }

    // Update the database
    $sql = "UPDATE invoicesetting SET 
    template_file = '$template_file',
    colour_code = '$colour_code',
    terms = '$terms',
    note = '$notes'";

// Add qrcode to query if uploaded
if (!empty($qrImagePath)) {
$sql .= ", qrcode = '$qrImagePath'";
}

$sql .= " WHERE id = 1";

mysqli_query($conn, $sql);

    // Prepare success response with data
    $response['status'] = 'success';
    $response['message'] = 'Data received and processed successfully.';
    $response['data'] = array(
        'notes' => $notes,
        'terms' => $terms,
        'imageSize' => $imageSize
    );

} else {
    // Prepare error response
    $response['message'] = 'Invalid request method.';
}

// Output the JSON response
echo json_encode($response);
?>
